/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractMultiset;
import org.python.google.common.collect.Collections2;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.Maps;
import org.python.google.common.collect.Multimap;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.Multisets;
import org.python.google.common.collect.SetMultimap;
import org.python.google.common.collect.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class AbstractMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;
    private transient Set<K> keySet;
    private transient Multiset<K> multiset;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> asMap;
    private static final long serialVersionUID = 2447537837011683357L;

    protected AbstractMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    final void setMap(Map<K, Collection<V>> map) {
        this.map = map;
        this.totalSize = 0;
        for (Collection<Collection<V>> collection : map.values()) {
            Preconditions.checkArgument(!collection.isEmpty());
            this.totalSize += collection.size();
        }
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@Nullable K k) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        for (Collection<V> collection : this.map.values()) {
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object object, @Nullable Object object2) {
        Collection<V> collection = this.map.get(object);
        return collection != null && collection.contains(object2);
    }

    @Override
    public boolean put(@Nullable K k, @Nullable V v) {
        Collection<V> collection = this.getOrCreateCollection(k);
        if (collection.add(v)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(@Nullable K k) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection(k);
            this.map.put(k, collection);
        }
        return collection;
    }

    @Override
    public boolean remove(@Nullable Object object, @Nullable Object object2) {
        Collection<V> collection = this.map.get(object);
        if (collection == null) {
            return false;
        }
        boolean bl = collection.remove(object2);
        if (bl) {
            --this.totalSize;
            if (collection.isEmpty()) {
                this.map.remove(object);
            }
        }
        return bl;
    }

    @Override
    public boolean putAll(@Nullable K k, Iterable<? extends V> iterable) {
        if (!iterable.iterator().hasNext()) {
            return false;
        }
        Collection<V> collection = this.getOrCreateCollection(k);
        int n = collection.size();
        boolean bl = false;
        if (iterable instanceof Collection) {
            Collection<? extends V> collection2 = Collections2.cast(iterable);
            bl = collection.addAll(collection2);
        } else {
            for (V v : iterable) {
                bl |= collection.add(v);
            }
        }
        this.totalSize += collection.size() - n;
        return bl;
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean bl = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            bl |= this.put(entry.getKey(), entry.getValue());
        }
        return bl;
    }

    @Override
    public Collection<V> replaceValues(@Nullable K k, Iterable<? extends V> iterable) {
        Iterator<V> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return this.removeAll(k);
        }
        Collection<V> collection = this.getOrCreateCollection(k);
        Collection<V> collection2 = this.createCollection();
        collection2.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator.hasNext()) {
            if (!collection.add(iterator.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(collection2);
    }

    @Override
    public Collection<V> removeAll(@Nullable Object object) {
        Collection<V> collection = this.map.remove(object);
        Collection<V> collection2 = this.createCollection();
        if (collection != null) {
            collection2.addAll(collection);
            this.totalSize -= collection.size();
            collection.clear();
        }
        return this.unmodifiableCollectionSubclass(collection2);
    }

    private Collection<V> unmodifiableCollectionSubclass(Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(@Nullable K k) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection(k);
        }
        return this.wrapCollection(k, collection);
    }

    private Collection<V> wrapCollection(@Nullable K k, Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(k, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(k, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(k, (List)collection, null);
        }
        return new WrappedCollection(k, collection, null);
    }

    private List<V> wrapList(@Nullable K k, List<V> list, @Nullable WrappedCollection wrappedCollection) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(k, list, wrappedCollection) : new WrappedList(k, list, wrappedCollection);
    }

    private Iterator<V> iteratorOrListIterator(Collection<V> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    public Set<K> keySet() {
        Set<K> set = this.keySet;
        return set == null ? (this.keySet = this.createKeySet()) : set;
    }

    private Set<K> createKeySet() {
        return this.map instanceof SortedMap ? new SortedKeySet((SortedMap)this.map) : new KeySet(this.map);
    }

    @Override
    public Multiset<K> keys() {
        MultisetView multisetView = this.multiset;
        return multisetView == null ? (this.multiset = new MultisetView()) : multisetView;
    }

    private int removeValuesForKey(Object object) {
        Collection<V> collection;
        try {
            collection = this.map.remove(object);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
        int n = 0;
        if (collection != null) {
            n = collection.size();
            collection.clear();
            this.totalSize -= n;
        }
        return n;
    }

    @Override
    public Collection<V> values() {
        Values values = this.valuesCollection;
        return values == null ? (this.valuesCollection = new Values()) : values;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> collection = this.entries;
        return collection == null ? (this.entries = this.createEntries()) : collection;
    }

    private Collection<Map.Entry<K, V>> createEntries() {
        return this instanceof SetMultimap ? new EntrySet() : new Entries();
    }

    Iterator<Map.Entry<K, V>> createEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> map = this.asMap;
        return map == null ? (this.asMap = this.createAsMap()) : map;
    }

    private Map<K, Collection<V>> createAsMap() {
        return this.map instanceof SortedMap ? new SortedAsMap((SortedMap)this.map) : new AsMap(this.map);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap multimap = (Multimap)object;
            return ((Object)this.map).equals(multimap.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMap
    extends AbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;
        transient Set<Map.Entry<K, Collection<V>>> entrySet;

        AsMap(Map<K, Collection<V>> map) {
            this.submap = map;
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            AsMapEntries asMapEntries = this.entrySet;
            return asMapEntries == null ? (this.entrySet = new AsMapEntries()) : asMapEntries;
        }

        @Override
        public boolean containsKey(Object object) {
            return Maps.safeContainsKey(this.submap, object);
        }

        @Override
        public Collection<V> get(Object object) {
            Collection collection = Maps.safeGet(this.submap, object);
            if (collection == null) {
                return null;
            }
            Object object2 = object;
            return AbstractMultimap.this.wrapCollection(object2, collection);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMultimap.this.keySet();
        }

        @Override
        public Collection<V> remove(Object object) {
            Collection collection = this.submap.remove(object);
            if (collection == null) {
                return null;
            }
            Collection collection2 = AbstractMultimap.this.createCollection();
            collection2.addAll(collection);
            AbstractMultimap.this.totalSize -= collection.size();
            collection.clear();
            return collection2;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || ((Object)this.submap).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.submap).hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AsMapEntries
        extends AbstractSet<Map.Entry<K, Collection<V>>> {
            AsMapEntries() {
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            public int size() {
                return AsMap.this.submap.size();
            }

            @Override
            public boolean contains(Object object) {
                return Collections2.safeContains(AsMap.this.submap.entrySet(), object);
            }

            @Override
            public boolean remove(Object object) {
                if (!this.contains(object)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                AbstractMultimap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            Collection<V> collection;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                Object k = entry.getKey();
                this.collection = entry.getValue();
                return Maps.immutableEntry(k, AbstractMultimap.this.wrapCollection(k, this.collection));
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends AbstractCollection<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.createEntryIterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMultimap.this.containsEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMultimap.this.remove(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        EntryIterator() {
            this.keyIterator = AbstractMultimap.this.map.entrySet().iterator();
            if (this.keyIterator.hasNext()) {
                this.findValueIteratorAndKey();
            } else {
                this.valueIterator = Iterators.emptyModifiableIterator();
            }
        }

        void findValueIteratorAndKey() {
            Map.Entry entry = this.keyIterator.next();
            this.key = entry.getKey();
            this.collection = entry.getValue();
            this.valueIterator = this.collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.valueIterator.hasNext()) {
                this.findValueIteratorAndKey();
            }
            return Maps.immutableEntry(this.key, this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMultimap.this.totalSize--;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        final Map<K, Collection<V>> subMap;

        KeySet(Map<K, Collection<V>> map) {
            this.subMap = map;
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<Map.Entry<K, Collection<V>>> entryIterator;
                Map.Entry<K, Collection<V>> entry;
                {
                    this.entryIterator = KeySet.this.subMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = this.entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null);
                    Collection collection = this.entry.getValue();
                    this.entryIterator.remove();
                    AbstractMultimap.this.totalSize -= collection.size();
                    collection.clear();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.subMap.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n = 0;
            Collection collection = this.subMap.remove(object);
            if (collection != null) {
                n = collection.size();
                collection.clear();
                AbstractMultimap.this.totalSize -= n;
            }
            return n > 0;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            return super.removeAll(collection);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.subMap.keySet().containsAll(collection);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return this == object || ((Object)this.subMap.keySet()).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.subMap.keySet()).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntry
    extends Multisets.AbstractEntry<K> {
        final Map.Entry<K, Collection<V>> entry;

        public MultisetEntry(Map.Entry<K, Collection<V>> entry) {
            this.entry = entry;
        }

        @Override
        public K getElement() {
            return this.entry.getKey();
        }

        @Override
        public int getCount() {
            return this.entry.getValue().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetEntryIterator
    implements Iterator<Multiset.Entry<K>> {
        final Iterator<Map.Entry<K, Collection<V>>> asMapIterator;

        private MultisetEntryIterator() {
            this.asMapIterator = AbstractMultimap.this.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.asMapIterator.hasNext();
        }

        @Override
        public Multiset.Entry<K> next() {
            return new MultisetEntry(this.asMapIterator.next());
        }

        @Override
        public void remove() {
            this.asMapIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetKeyIterator
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private MultisetKeyIterator() {
            this.entryIterator = AbstractMultimap.this.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return this.entryIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultisetView
    extends AbstractMultiset<K> {
        transient Set<Multiset.Entry<K>> entrySet;

        private MultisetView() {
        }

        @Override
        public int remove(Object object, int n) {
            Collection collection;
            if (n == 0) {
                return this.count(object);
            }
            Preconditions.checkArgument(n > 0);
            try {
                collection = (Collection)AbstractMultimap.this.map.get(object);
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
            if (collection == null) {
                return 0;
            }
            int n2 = collection.size();
            if (n >= n2) {
                return AbstractMultimap.this.removeValuesForKey(object);
            }
            Iterator iterator = collection.iterator();
            for (int i = 0; i < n; ++i) {
                iterator.next();
                iterator.remove();
            }
            AbstractMultimap.this.totalSize -= n;
            return n2;
        }

        @Override
        public Set<K> elementSet() {
            return AbstractMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            EntrySet entrySet = this.entrySet;
            return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
        }

        @Override
        public Iterator<K> iterator() {
            return new MultisetKeyIterator();
        }

        @Override
        public int count(Object object) {
            try {
                Collection collection = (Collection)AbstractMultimap.this.map.get(object);
                return collection == null ? 0 : collection.size();
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Multiset.Entry<K>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Multiset.Entry<K>> iterator() {
                return new MultisetEntryIterator();
            }

            @Override
            public int size() {
                return AbstractMultimap.this.map.size();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Multiset.Entry)) {
                    return false;
                }
                Multiset.Entry entry = (Multiset.Entry)object;
                Collection collection = (Collection)AbstractMultimap.this.map.get(entry.getElement());
                return collection != null && collection.size() == entry.getCount();
            }

            @Override
            public void clear() {
                AbstractMultimap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                return this.contains(object) && AbstractMultimap.this.removeValuesForKey(((Multiset.Entry)object).getElement()) > 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(K k, @Nullable List<V> list, WrappedCollection wrappedCollection) {
            super(k, list, wrappedCollection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedAsMap
    extends AsMap
    implements SortedMap<K, Collection<V>> {
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedMap<K, Collection<V>> headMap(K k) {
            return new SortedAsMap(this.sortedMap().headMap(k));
        }

        @Override
        public SortedMap<K, Collection<V>> subMap(K k, K k2) {
            return new SortedAsMap(this.sortedMap().subMap(k, k2));
        }

        @Override
        public SortedMap<K, Collection<V>> tailMap(K k) {
            return new SortedAsMap(this.sortedMap().tailMap(k));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedKeySet sortedKeySet = this.sortedKeySet;
            return sortedKeySet == null ? (this.sortedKeySet = new SortedKeySet(this.sortedMap())) : sortedKeySet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.subMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedSet<K> headSet(K k) {
            return new SortedKeySet(this.sortedMap().headMap(k));
        }

        @Override
        public K last() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedSet<K> subSet(K k, K k2) {
            return new SortedKeySet(this.sortedMap().subMap(k, k2));
        }

        @Override
        public SortedSet<K> tailSet(K k) {
            return new SortedKeySet(this.sortedMap().tailMap(k));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private ValueIterator() {
            this.entryIterator = AbstractMultimap.this.createEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return AbstractMultimap.this.containsValue(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final WrappedCollection ancestor;
        final Collection<V> ancestorDelegate;

        WrappedCollection(K k, @Nullable Collection<V> collection, WrappedCollection wrappedCollection) {
            this.key = k;
            this.delegate = collection;
            this.ancestor = wrappedCollection;
            this.ancestorDelegate = wrappedCollection == null ? null : wrappedCollection.getDelegate();
        }

        void refreshIfEmpty() {
            Collection collection;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (collection = (Collection)AbstractMultimap.this.map.get(this.key)) != null) {
                this.delegate = collection;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                AbstractMultimap.this.map.remove(this.key);
            }
        }

        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                AbstractMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return ((Object)this.delegate).equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        @Override
        public boolean add(V v) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.isEmpty();
            boolean bl2 = this.delegate.add(v);
            if (bl2) {
                AbstractMultimap.this.totalSize++;
                if (bl) {
                    this.addToMap();
                }
            }
            return bl2;
        }

        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n = this.size();
            boolean bl = this.delegate.addAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMultimap.this.totalSize += n2 - n;
                if (n == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        @Override
        public boolean contains(Object object) {
            this.refreshIfEmpty();
            return this.delegate.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(collection);
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMultimap.this.totalSize -= n;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(Object object) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.remove(object);
            if (bl) {
                AbstractMultimap.this.totalSize--;
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n = this.size();
            boolean bl = this.delegate.removeAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMultimap.this.totalSize += n2 - n;
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            int n = this.size();
            boolean bl = this.delegate.retainAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMultimap.this.totalSize += n2 - n;
                this.removeIfEmpty();
            }
            return bl;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = AbstractMultimap.this.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> iterator) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = iterator;
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMultimap.this.totalSize--;
                WrappedCollection.this.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedList
    extends WrappedCollection
    implements List<V> {
        WrappedList(K k, @Nullable List<V> list, WrappedCollection wrappedCollection) {
            super(k, list, wrappedCollection);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        @Override
        public boolean addAll(int n, Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl = this.getListDelegate().addAll(n, collection);
            if (bl) {
                int n3 = this.getDelegate().size();
                AbstractMultimap.this.totalSize += n3 - n2;
                if (n2 == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        @Override
        public V get(int n) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(n);
        }

        @Override
        public V set(int n, V v) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(n, v);
        }

        @Override
        public void add(int n, V v) {
            this.refreshIfEmpty();
            boolean bl = this.getDelegate().isEmpty();
            this.getListDelegate().add(n, v);
            AbstractMultimap.this.totalSize++;
            if (bl) {
                this.addToMap();
            }
        }

        @Override
        public V remove(int n) {
            this.refreshIfEmpty();
            Object v = this.getListDelegate().remove(n);
            AbstractMultimap.this.totalSize--;
            this.removeIfEmpty();
            return v;
        }

        @Override
        public int indexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(object);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int n) {
            this.refreshIfEmpty();
            return new WrappedListIterator(n);
        }

        @Override
        public List<V> subList(int n, int n2) {
            this.refreshIfEmpty();
            return AbstractMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList(n, n2), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * Signature claims super is org.python.google.common.collect.AbstractMultimap$WrappedCollection.WrappedIterator, not org.python.google.common.collect.AbstractMultimap$WrappedCollection$WrappedIterator - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int n) {
                super(WrappedList.this.getListDelegate().listIterator(n));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(V v) {
                this.getDelegateListIterator().set(v);
            }

            public void add(V v) {
                boolean bl = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(v);
                AbstractMultimap.this.totalSize++;
                if (bl) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        WrappedSet(K k, Set<V> set) {
            super(k, set, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet<V> {
        WrappedSortedSet(K k, @Nullable SortedSet<V> sortedSet, WrappedCollection wrappedCollection) {
            super(k, sortedSet, wrappedCollection);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        @Override
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        @Override
        public SortedSet<V> headSet(V v) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(v), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> subSet(V v, V v2) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(v, v2), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> tailSet(V v) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(v), this.getAncestor() == null ? this : this.getAncestor());
        }
    }
}

